/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.uicontrols.expressionbuilder;

import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWSchema;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWXMLData;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.IVWDescriptionPanel;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.VWExpressionItem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class VWXMLDataFieldDescriptionPanel
extends JPanel
implements IVWDescriptionPanel,
ActionListener {
    private VWToolbarBorder m_nameBorder = null;
    private JTextField m_name = null;
    private VWToolbarBorder m_schemaBorder = null;
    private JTextField m_schema = null;
    private JButton m_schemaButton = null;
    private VWToolbarBorder m_elementBorder = null;
    private JTextField m_element = null;
    private VWToolbarBorder m_descriptionBorder = null;
    private JTextArea m_description = null;
    private GridBagConstraints m_gbCons = null;
    private VWWorkflowDefinition m_wfDef = null;
    private JDialog m_parentDialog = null;
    private VWFieldDefinition m_fieldDefinition = null;
    private VWExpressionItem m_expressionItem = null;

    public VWXMLDataFieldDescriptionPanel(JDialog parentDialog, VWWorkflowDefinition wfDef) {
        this.m_parentDialog = parentDialog;
        this.m_wfDef = wfDef;
    }

    public void init() {
        this.setLayout(new GridBagLayout());
        this.m_gbCons = new GridBagConstraints();
        this.initControls();
    }

    public void clean() {
        this.m_name.setText("");
        this.m_schema.setText("");
        this.m_element.setText("");
        this.m_description.setText("");
    }

    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src == this.m_schemaButton) {
            this.performSchemaButtonAction();
        }
    }

    public void setExpressionItem(VWExpressionItem item) {
        Object expressionItem;
        this.m_expressionItem = item;
        this.m_fieldDefinition = null;
        if (item != null && (expressionItem = item.getExpressionItem()) instanceof VWFieldDefinition) {
            this.m_fieldDefinition = (VWFieldDefinition)expressionItem;
        }
        this.reinitialize();
    }

    public String getExpressionItem() {
        String expressionItem = null;
        try {
            if (this.m_expressionItem != null) {
                expressionItem = this.m_expressionItem.toString();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return expressionItem;
    }

    private void initControls() {
        this.m_gbCons.anchor = 23;
        this.m_gbCons.fill = 2;
        this.m_gbCons.gridx = 0;
        this.m_gbCons.gridy = 0;
        this.m_gbCons.weightx = 1.0;
        this.m_gbCons.weighty = 0.0;
        this.m_gbCons.gridheight = 1;
        this.m_gbCons.gridwidth = 1;
        this.m_gbCons.insets = new Insets(0, 2, 0, 0);
        this.m_nameBorder = new VWToolbarBorder(VWResource.s_name);
        this.add((Component)this.m_nameBorder, this.m_gbCons);
        JPanel namePanel = this.m_nameBorder.getClientPanel();
        namePanel.setLayout(new GridLayout());
        this.m_name = new JTextField();
        this.m_name.setEditable(false);
        namePanel.add(this.m_name);
        this.m_gbCons.anchor = 23;
        this.m_gbCons.fill = 2;
        this.m_gbCons.gridx = 0;
        this.m_gbCons.gridy = 1;
        this.m_gbCons.weightx = 1.0;
        this.m_gbCons.weighty = 0.0;
        this.m_gbCons.gridheight = 1;
        this.m_gbCons.gridwidth = 1;
        this.m_gbCons.insets = new Insets(0, 2, 0, 0);
        this.m_schemaBorder = new VWToolbarBorder(VWResource.s_schema);
        this.add((Component)this.m_schemaBorder, this.m_gbCons);
        JPanel schemaPanel = this.m_schemaBorder.getClientPanel();
        schemaPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.anchor = 23;
        gbCons.fill = 1;
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.weightx = 1.0;
        gbCons.weighty = 0.0;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.insets = new Insets(0, 0, 0, 0);
        this.m_schema = new JTextField();
        this.m_schema.setEditable(false);
        schemaPanel.add((Component)this.m_schema, gbCons);
        gbCons.anchor = 23;
        gbCons.fill = 3;
        gbCons.gridx = 1;
        gbCons.gridy = 0;
        gbCons.weightx = 0.0;
        gbCons.weighty = 0.0;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.insets = new Insets(0, 0, 0, 0);
        this.m_schemaButton = VWImageLoader.createIconButton("dots.gif", VWResource.s_schemaDetail);
        this.m_schemaButton.addActionListener(this);
        schemaPanel.add((Component)this.m_schemaButton, gbCons);
        this.m_gbCons.anchor = 23;
        this.m_gbCons.fill = 2;
        this.m_gbCons.gridx = 0;
        this.m_gbCons.gridy = 2;
        this.m_gbCons.weightx = 1.0;
        this.m_gbCons.weighty = 0.0;
        this.m_gbCons.gridheight = 1;
        this.m_gbCons.gridwidth = 1;
        this.m_gbCons.insets = new Insets(0, 2, 0, 0);
        this.m_elementBorder = new VWToolbarBorder(VWResource.s_element);
        this.add((Component)this.m_elementBorder, this.m_gbCons);
        JPanel elementPanel = this.m_elementBorder.getClientPanel();
        elementPanel.setLayout(new GridLayout());
        this.m_element = new JTextField();
        this.m_element.setEditable(false);
        elementPanel.add(this.m_element);
        this.m_gbCons.fill = 1;
        this.m_gbCons.anchor = 23;
        this.m_gbCons.gridx = 0;
        this.m_gbCons.gridy = 3;
        this.m_gbCons.weightx = 1.0;
        this.m_gbCons.weighty = 1.0;
        this.m_gbCons.gridheight = 1;
        this.m_gbCons.gridwidth = 1;
        this.m_gbCons.insets = new Insets(0, 2, 0, 0);
        this.m_gbCons.weighty = 1.0;
        this.m_descriptionBorder = new VWToolbarBorder(VWResource.s_description);
        this.add((Component)this.m_descriptionBorder, this.m_gbCons);
        JPanel descriptionPanel = this.m_descriptionBorder.getClientPanel();
        descriptionPanel.setLayout(new GridLayout());
        this.m_description = new JTextArea();
        this.m_description.setEditable(false);
        descriptionPanel.add(new JScrollPane(this.m_description));
    }

    private void reinitialize() {
        try {
            if (this.m_fieldDefinition != null) {
                this.m_name.setText(this.m_fieldDefinition.getName());
                VWXMLData xmlData = (VWXMLData)this.m_fieldDefinition.getValue();
                if (xmlData != null) {
                    this.m_schema.setText(xmlData.getSchemaName());
                    this.m_element.setText(xmlData.getElementName());
                }
                this.m_description.setText(this.m_fieldDefinition.getDescription());
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performSchemaButtonAction() {
        block5: {
            try {
                VWSchema[] schemas;
                String schemaName;
                if (this.m_fieldDefinition == null || (schemaName = this.m_fieldDefinition.getXMLSchemaName()) == null || schemaName.length() <= 0 || this.m_wfDef == null || (schemas = this.m_wfDef.getSchemas()) == null) break block5;
                VWSchema schema = null;
                for (int i = 0; i < schemas.length; ++i) {
                    if (VWStringUtils.compare(schemaName, schemas[i].getName()) != 0) continue;
                    schema = schemas[i];
                    break;
                }
                if (schema == null) break block5;
                String schemaDetail = schema.getSchema();
                try {
                    schemaDetail = VWStringUtils.xmlPrettyFormat(schemaDetail);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                VWMessageDialog.showOptionDialog(this.m_parentDialog, schemaDetail, VWResource.s_schemaDetail, 2);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }
}

